Attribute VB_Name = "mMain"
Option Explicit

' /////////////////////////////////////////////////////////////////////////////
' Test/example code for Visual BASIC Callbacks tutorial
' Located at: http://software.kerys.co.uk/vb/callbacks.htm
' M Shaw - August 2010
' Public Domain - no copyright: but please credit
' /////////////////////////////////////////////////////////////////////////////
' Versions:
' 1.00 06/Aug/2010 - First version
' /////////////////////////////////////////////////////////////////////////////
' Note: Ensure you copy vbcallback.dll to a PATH-ed location
'       such as your WINDIR directory (C:\WINDOWS)
'       Since the tutorial uses only Debug.Print output and VB5 has no console
'       Output then a simple MsgBox message has been added for compiled use
' /////////////////////////////////////////////////////////////////////////////

Public Declare Sub Foo Lib "VBCallback" (ByVal Pointer As Long)
Public Msg As String ' Since we have no console output we use this to accumulate o/p
Public Const WEBURL As String = "http://software.kerys.co.uk/vb/callbacks.htm" ' Added for compiled EXE only

Sub Main()
    ' We compile to start with Sub Main() for compiled EXE examples
    TestCallback    ' You could rename TestCallback() as Main() if you wished
    End
End Sub
Public Sub TestCallback()
  ' Test routine which simply calls the DLL which, in turn calls the callback procedure
  Dim LongVal As Long
  Dim i As Integer
  On Error GoTo Error

  LongVal = GetProcAddress(AddressOf MyProc)
  Debug.Print "Test address is "; LongVal
  For i = 1 To 10  ' We will call our external function 10 times
    Foo LongVal    ' Call the DLL with the procedure-address of MyProc()
  Next
  MsgBox Msg, vbInformation, WEBURL       ' Message for compiled EXEs only
  
Fail:
  Exit Sub
  
Error:
    MsgBox "Error: " & CStr(Err.Number) & " ( " & Err.Description & " ) in TestCallback()", vbCritical
    Resume Fail
End Sub
Public Sub MyProc(ByVal s As String, ByVal i As Integer)
  ' This is the callback procedure
  Dim m As String
  Static Count As Integer
  
  Debug.Print "Entered VB callback code"
  Count = Count + 1
  
  ' Since a compiled EXE demo has no Debug.Print output we add this string message
  m = "Callback call: " & Format$(Count, "00")
  Msg = Msg & m & " - (s=[" & s & "], i=" & CStr(i) & ")" & vbCrLf
  
  Debug.Print m
  Debug.Print "DLL Parameter s is ["; s; "]"
  Debug.Print "DLL Parameter i is ["; i; "]"
  
End Sub
Public Function GetProcAddress(ByVal Addr As Long) As Long
  ' Service routine
  ' Purpose: Return a procedure's address
  ' Call as x=GetProcAddress(AddressOf Procedure)
  GetProcAddress = Addr
End Function
